/**
* Copyright (C) 2019-2021, ɴϢ޹˾
* @brief    Xone 2.0APIӿ
* @author   Xone Ŀ
* @date     2019816
* @note     Xone 2.0/3.0̨ûAPIֲ
*/


#ifndef DFITCMDAPI_H_
#define DFITCMDAPI_H_
#include <vector>
#include <string>
#include "DFITCApiStruct.h"

#ifdef WIN32_DLL
#ifdef DFITCAPI_EXPORTS
#define MDAPI_API __declspec(dllexport)
#else
#define MDAPI_API __declspec(dllimport)
#endif//DFITCAPI_EXPORTS
#elif defined(WIN32) || defined(_WIN32)
#define MDAPI_API
#endif//WIN32

#if !defined(WIN32) && !defined(_WIN32)
#define MDAPI_API __attribute__((visibility("default")))
#endif


namespace DFITCXSPEEDMDAPI {
    /**
    * @brief    ûӦصӿ
    * @details  ʵ¼֪ͨӿڣûҪʵִӿڣд¼ûȤ¼
    * @note     Init
    */
    class MDAPI_API DFITCMdSpi
    {
    public:
        /**
        * @brief  캯
        * @return 
        */
        DFITCMdSpi() {}

        /**
        * @brief   Ӧ
        * @return  
        */
        virtual void OnFrontConnected() {}

        /**
        * @brief  Ӧ
        * @param  nReason : Ͽԭ
        * @return  
        */
        virtual void OnFrontDisconnected(int nReason) {}

        /**
         * @brief  ½Ӧ : û¼ǰûӦʱ˷ᱻã֪ͨû¼Ƿɹ
         * @param  pRspUserLogin : û¼Ϣṹַ
         * @param  pRspInfo : ʧܣشϢַýṹдϢ
         * @return 
         */
        virtual void OnRspUserLogin(struct DFITCUserLoginInfoRtnField* pRspUserLogin, struct DFITCErrorRtnField* pRspInfo) {}

        /**
         * @brief  ǳӦ : û˳ǰûӦ˷ᱻã֪ͨû˳״̬
         * @param  pRspUsrLogout : û˳Ϣṹַ
         * @param  pRspInfo : ʧܣشϢַ
         * @return 
         */
        virtual void OnRspUserLogout(struct DFITCUserLogoutInfoRtnField* pRspUsrLogout, struct DFITCErrorRtnField* pRspInfo) {}

        /**
         * @brief  Ӧ
         * @param  pRspInfo : Ϣַ
         * @return 
         */
        virtual void OnRspError(struct DFITCErrorRtnField* pRspInfo) {}

        /**
         * @brief  鶩Ӧ : û鶩ĸ÷ᱻá
         * @param  pSpecificInstrument : ָԼӦṹýṹԼϢ
         * @param  pRspInfo : Ϣ󣬸ýṹдϢ
         * @return 
         */
        virtual void OnRspSubMarketData(struct DFITCSpecificInstrumentField* pSpecificInstrument, struct DFITCErrorRtnField* pRspInfo) {}

        /**
         * @brief  ȡӦ :û˶÷ᱻá
         * @param  pSpecificInstrument : ָԼӦṹýṹԼϢ
         * @param  pRspInfo : Ϣ󣬸ýṹдϢ
         * @return 
         */
        virtual void OnRspUnSubMarketData(struct DFITCSpecificInstrumentField* pSpecificInstrument, struct DFITCErrorRtnField* pRspInfo) {}

        /**
         * @brief  鶩Ӧ : û鶩ĸ÷ᱻá
         * @param  DFITCQuotRspField : ָӦṹýṹԼϢ
         * @param  subFailVec : ʧܵĺԼƷּϡ
         * @param  errVec : ʧܵĴַ
         * @return 
         */
        virtual void OnRspSubQuotData(struct DFITCQuotRspField& quotRspInfo, DFITCQuotErrField& errInfo) {}

        /**
         * @brief  ȡӦ : û鶩ĸ÷ᱻá
         * @param  DFITCQuotRspField : ָӦṹýṹԼϢ
         * @param  subFailVec : ȡʧܵĺԼƷּϡ
         * @param  errVec : ȡʧܵĴַ
         * @return 
         */
        virtual void OnRspUnSubQuotData(struct DFITCQuotRspField& quotRspInfo, DFITCQuotErrField& errInfo) {}

        /**
         * @brief  ϢӦ : ɹ鷵ʱ÷ᱻá
         * @param  pMarketDataField : ָϢṹָ룬ṹаϢ
         * @return 
         */
        virtual void OnMarketData(struct DFITCDepthMarketDataField* pMarketDataField) {}

        /**
        * @brief  ϢӦ : ѯɹ鷵ʱ÷ᱻá
        * @param  pMarketDataField : ָϢṹָ룬ṹаϢ
        * @param  pMarketDataField : ָϢṹָ룬ṹаϢ
        * @return 
        */
        virtual void OnMarketSnapShotData(struct DFITCDepthMarketDataField* pMarketDataField, bool bIsLast) {}
        /**
        * 鶩Ӧ:û鶩ĸ÷ᱻá
        * @param pSpecificInstrument:ָԼӦṹýṹԼϢ
        * @param pRspInfo:Ϣ󣬸ýṹдϢ
        */
        virtual void OnRspMarketSnapShotData(struct DFITCSpecificInstrumentField* pSpecificInstrument, struct DFITCErrorRtnField* pRspInfo) {}


        /**
         * @brief  Ӧ : ڵʱ򣬸÷ᱻá
         * @param  pTradingDayRtnData : ָϢָ룬ṹаĽϢ
         * @return 
         */
        virtual void  OnRspTradingDay(struct DFITCTradingDayRtnField* pTradingDayRtnData) {}

    };//end of DFITCMdSpi

    class MDAPI_API DFITCMdApi
    {
    public:
        /**
         * @brief     APIʵ
         * @return    UserApiʵָ
         * @attention ̬
         */
        static DFITCMdApi* CreateDFITCMdApi(void);

        /**
         * @brief   һϵгʼ:עصӿ,ǰá
         * @param   pszFrontAddr : ǰַ
         *                  ַĸʽΪ : protocol://ipaddress:port, tcp://127.0.0.1:10915
         *                  ipaddressʾǰõIP,portʾǰõĶ˿
         * @param   pSpi : DFITCMdSpiʵָ
         * @param   output_code : ̰߳CPU
         * @param   input_code  : ̰߳CPU
         * @return  ʼִн
         *         <ul>
         *           <li>  0 - ʼɹ
         *           <li> -1 - ʼʧ
         *         </ul>
         */
        virtual int Init(const char* pszFrontAddr, DFITCMdSpi* pSpi, int output_code, int input_code) = 0;

        /**
        * @brief     ɾӿڶʹñӿڶʱ,øúɾӿڶ
        * @return    ֵ
        */
        virtual void Release(void) = 0;

        /**
         * @brief   ȴӿ߳̽С
         * @return  ߳˳
         *         <ul>
         *           <li>  0 - ߳˳ɹ
         *           <li> -1 - ߳˳ʧ
         *         </ul>
         */
        virtual int Join(void) = 0;

        /**
         * @brief   :÷ĳĳЩԼ
         * @param   ppInstrumentID[] : ָ飬ÿָָһԼ*кԼҲɶĳкԼDCE
         * @param   nCount : Լ
         * @param   nRequestID : ID
         * @return  ͽ
         *         <ul>
         *           <li>  0 - ͳɹ
         *           <li> -1 - ʧ
         *         </ul>
         */
        virtual int SubscribeMarketData(char* ppInstrumentID[], int nCount, int nRequestID) = 0;

        /**
         * @brief   ˶ : ÷˶ĳ/ĳЩԼ
         * @param   ppInstrumentID[] : ָ飬ÿָָһԼ*˶кԼҲ˶ĳкԼDCE
         * @param   nCount : Լ
         * @param   nRequestID : ID
         * @return  ˶ͽ
         *         <ul>
         *           <li>  0 - ˶ͳɹ
         *           <li> -1 - ˶ʧ
         *         </ul>
         */
        virtual int UnSubscribeMarketData(char* ppInstrumentID[], int nCount, int nRequestID) = 0;
        
        /**
        * @brief   :÷
        * @param   SubType : 
        * @param   SubVec : 
        * @param   RequestID : ID
        * @return  ͽ
        *         <ul>
        *           <li>  0 - ͳɹ
        *           <li> -1 - ʧ
        *         </ul>
        */
        virtual int SubQuotData(DFITCQuotSubType SubType, const DFITCExchangeName& ExchangeName,  const std::vector<DFITCSubDataType>& SubVec, DFITCRequestIDType RequestID) = 0;

        /**
         * @brief   ˶ : ÷˶ĳ/ĳЩԼ
         * @param   UnSubType : ˶
         * @param   UnSubVec : 
         * @param   RequestID : ID
         * @return  ˶ͽ
         *         <ul>
         *           <li>  0 - ˶ͳɹ
         *           <li> -1 - ˶ʧ
         *         </ul>
         */
        virtual int UnSubQuotData(DFITCQuotSubType UnSubType, const DFITCExchangeName& ExchangeName, const std::vector<DFITCSubDataType>& UnSubVec, DFITCRequestIDType RequestID) = 0;

        /**
         * @brief   û½
         * @param   pReqUserLoginField : ָû¼ṹĵַ
         * @return  ͽ
         *         <ul>
         *           <li>  0 - ͳɹ
         *           <li> -1 - ʧ
         *           <li> -2 - 쳣
         *         </ul>
         */
        virtual int ReqUserLogin(struct DFITCUserLoginField* pReqUserLoginField) = 0;

        /**
         * @brief   ûǳ
         * @param   pReqUserLogoutField : ָû¼ṹĵַ
         * @return  ͽ
         *         <ul>
         *           <li>  0 - ͳɹ
         *           <li> -1 - ʧ
         *           <li> -2 - 쳣
         *         </ul>
         */
        virtual int ReqUserLogout(struct DFITCUserLogoutField* pReqUserLogoutField) = 0;
        /**
        * ղѯ
        * @param pTradingDay:ָղѯṹַ
        * @return 0 - ͳɹ; -1 - ʧ
        */
        virtual int ReqTradingDay(struct DFITCTradingDayField* pTradingDay, int excg_id) = 0;
        /**
        * @brief   ղѯ
        * @param   pTradingDay : ָղѯṹַ
        * @return  ѯͽ
        *         <ul>
        *           <li>  0 - ѯͳɹ
        *           <li> -1 - ѯʧ
        *         </ul>
        */
        virtual int ReqQuotMarketSnapShot(char* ppInstrumentID[], int nCount, int nRequestID) = 0;
        /**
        * @brief   api logȼˢ¼첽log,ʼɹ,Ч
        * @param   log_level : ־
        * @param   flush_level : ־д̼
        * @return  
        * @note    ĬϲҲֱ޲ε
        */
        virtual void SetLogLevel(int log_level = 3, int flush_level = 3) = 0;

        /**
        * @brief  busypollingٽ
        * @param [in] low  ֵڴֵ˳busypollingģʽ
        * @param [in] high ֵڴֵbusypollingģʽ
        * @return ֵ
        *         <ul>
        *           <li> true      -  óɹ
        *           <li> false     -  Ч
        *         </ul>
        */
        virtual bool SetBusyPolling(unsigned int low, unsigned int high) = 0;

    public:
        DFITCMdApi();
        virtual ~DFITCMdApi();

    };//end of MDAPI_API
} //end of namespace

#endif//DFITCMDAPI_H_
